// XISLRootTag.cpp: CXISLRootTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLRootTag.h"
#include "XISLVarList.h"
#include "XISLVar.h"
#include "MainFrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CXISLRootTag *g_pAppRootTag;
//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLRootTag::CXISLRootTag()
{
	m_nTagType = ID_TAG_XISL;
	m_bAppRoot = FALSE;
	m_strDocName = "";
	m_pDocumentVar = new CXISLVarList(this);
	m_pParentTag = this;
}

CXISLRootTag::~CXISLRootTag()
{
	((CMainFrame*)AfxGetApp()->m_pMainWnd)->ReplaceDTag2NCDTag(this);
	POSITION pos = m_xislList.GetHeadPosition();
	while(pos)
	{
		CXISLDialogTag *pDialogItem = (CXISLDialogTag*)m_xislList.GetNext(pos);
		delete (CXISLDialogTag*)pDialogItem;
	}
	//AvP[V[gȂChLgϐ
	//ׂẴhLgĂŌCMainFrame폜܂
	if(!IsAppRoot())
	{
		if(m_pDocumentVar)
		{
			delete m_pDocumentVar;
			m_pDocumentVar = NULL;
		}
	}
}

CXISLRootTag::CXISLRootTag(const CXISLRootTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;


	for(int i=0;i<m_xislList.GetCount();i++)
	{
		POSITION pos = cpXISL.m_xislList.FindIndex(i);
		m_xislList.AddTail(cpXISL.m_xislList.GetAt(pos));
	}
	m_htreeBody = cpXISL.m_htreeBody;
	m_strAppRoot = cpXISL.m_strAppRoot;
	m_strDocName = cpXISL.m_strDocName;
}

CXISLRootTag& CXISLRootTag::operator=(const CXISLRootTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		//łɃXg݂ĂȂ
		for(int i=0;i<m_xislList.GetCount();i++)
		{
			POSITION pos = m_xislList.FindIndex(i);
			CXISLDialogTag *pDialogItem = (CXISLDialogTag*)m_xislList.GetAt(pos);
			delete (CXISLDialogTag*)pDialogItem;
		}
		m_xislList.RemoveAll();

		for(i=0;i<m_xislList.GetCount();i++)
		{
			POSITION pos = cpXISL.m_xislList.FindIndex(i);
			m_xislList.AddTail(cpXISL.m_xislList.GetAt(pos));
		}
		m_htreeBody = cpXISL.m_htreeBody;
		m_strAppRoot = cpXISL.m_strAppRoot;
		m_strDocName = cpXISL.m_strDocName;
	}
	
	return *this;
}

//CSize CXISLRootTag::DrawDialogFlow(CDC *pDC,int nX,int nY)
//@\@FDialog̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLRootTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nViewSizeX,nViewSizeY;
	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);

	CBitmap FlowBMP;
	BITMAP bmp;

	FlowBMP.LoadBitmap(m_nBmpID);
	FlowBMP.GetBitmap(&bmp);
	CBitmap *pOldBMP = MemDC.SelectObject(&FlowBMP);
	FlowBMP.DeleteObject();

	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,255));
	pOldPen = pDC->SelectObject(&linePen);

	int nCount = m_xislList.GetCount();
	int *npExcPoint = new int[nCount];
	for(int i=0;i<nCount;i++)
	{
		POSITION pos = m_xislList.FindIndex(i);
		CXISLDialogTag *pDialogTag = (CXISLDialogTag*)m_xislList.GetAt(pos);

		FlowBMP.LoadBitmap(pDialogTag->m_nBmpID);

		FlowBMP.GetBitmap(&bmp);
		MemDC.SelectObject(&FlowBMP);
		if(pDialogTag->IsSubDialog())
		{
			pDC->BitBlt(nX+100,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
			pDialogTag->SetRectBMP(nX+100,nY,bmp.bmWidth,bmp.bmHeight);
		}
		else
		{
			pDC->BitBlt(nX,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
			pDialogTag->SetRectBMP(nX,nY,bmp.bmWidth,bmp.bmHeight);
		}

		FlowBMP.DeleteObject();
		npExcPoint[i] = nX+bmp.bmWidth/2;

		nY += 150;
	}

	nViewSizeY = nY;
	nViewSizeX = bmp.bmWidth;

	delete [] npExcPoint;
	MemDC.SelectObject(pOldBMP);
	FlowBMP.DeleteObject();
	MemDC.DeleteDC();

	return CSize(nViewSizeX+100,nViewSizeY+100);
}

//LPCTSTR CXISLRootTag::GetXISLString()
//@\@FXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLRootTag::GetXISLString()
{
	m_strXISL = "<?xml version=\"1.0\" encoding=\"Shift_JIS\" standalone=\"no\" ?>\r\n";
	m_strXISL += "<!DOCTYPE xisl SYSTEM \"./xisl01.dtd\">\r\n";
	m_strXISL += "<xisl version=\"1.1";
	
	if(!IsAppRoot() && g_pAppRootTag)
	{
		m_strXISL += "\" application=\"";
		m_strXISL += g_pAppRootTag->GetAppRootName();
	}
	m_strXISL += "\" >\r\n";

	m_strXISL += "<body>\r\n";
	if(m_pDocumentVar)
	{
		CString strTemp;
		m_pDocumentVar->GetXISLString(strTemp);
		m_strXISL += strTemp;
	}

	int nCount = m_xislList.GetCount();
	for(int i=0; i<nCount; i++)
	{
		POSITION pos = m_xislList.FindIndex(i);
		CXISLDialogTag *pDialogTag = (CXISLDialogTag*)m_xislList.GetAt(pos);
		m_strXISL += pDialogTag->GetXISLString();
	}

	m_strXISL += "</body>\r\n";
	m_strXISL += "</xisl>";

	return m_strXISL;
}


//int CXISLRootTag::GetItemCount()
//@\@FXISL̃c[ڐԂ
//@F
//߂lFintCc[ڐ
int CXISLRootTag::GetItemCount()
{
	int nDialog = m_xislList.GetCount();
	int nItem = 0;
	for(int i=0; i<nDialog; i++)
	{
		POSITION pos = m_xislList.FindIndex(i);
		CXISLDialogTag *pDialogTag = (CXISLDialogTag*)m_xislList.GetAt(pos);
		nItem += pDialogTag->GetItemCount();
	}

	return nItem + 2;  //<xisl>C<body>̕
}

void CXISLRootTag::SetDocName(LPCTSTR lpszDocName)
{
	m_strDocName = lpszDocName;
	if(m_strDocName.Find(".xisl") == -1)
		m_strDocName += ".xisl";
}

//CXISLTag* CXISLRootTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLRootTag::FindTag(POINT point,BOOL bOnly)
{
	CXISLTag* pTag;
	for(int i=0;i<m_xislList.GetCount();i++)
	{
		POSITION pos = m_xislList.FindIndex(i);
		CXISLDialogTag* pDialog = (CXISLDialogTag*)m_xislList.GetAt(pos);

		pTag = pDialog->FindTag(point,TRUE);
		if(pTag)
			return pTag;
	}

	return NULL;
}

//BOOL CXISLRootTag::RegistXISLTree(CTreeCtrl &pTree)
//@\@Fc[Rg[XISL^Oo^
//@Fo^c[Rg[
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLRootTag::RegistXISLTree(CTreeCtrl *pTree)
{
	pTree->DeleteAllItems();
	//c[ɓo^ׂ̕ϐ
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;
	HTREEITEM hParent;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = TVI_ROOT;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_XISL];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	tvi.pszText = XISL_TAG_NAME[ID_TAG_BODY];
	tvi.lParam = (LPARAM)this;
	tvs.item = tvi;
	tvs.hParent = hParent;
	hParent = pTree->InsertItem(&tvs);
	m_htreeBody = hParent;

	for(int i=0; i<m_xislList.GetCount(); i++)
	{
		POSITION pos = m_xislList.FindIndex(i);
		CXISLDialogTag *pDialog = (CXISLDialogTag*)m_xislList.GetAt(pos);
		pDialog->RegistXISLTree(pTree,hParent);
	}

	return TRUE;
}

//CXISLDialogTag* CXISLRootTag::CreateDialogTag()
//@\@Fdialog쐬
//@FȂ
//ԂlFCXISLDialogTag*@sFNULL
//CXISLDialogTag* CXISLRootTag::CreateDialogTag(LPCTSTR lpszID,int nComb,int nRepeat,int nScope,LPCTSTR lpszArg)
//{
//	CXISLDialogTag *pDialogTag;
//	pDialogTag = new CXISLDialogTag((CXISLTag*)this,lpszID,nComb,nRepeat,nScope,lpszArg);
//
//	m_nDialogNum++;
//	m_xislList.AddTail(pDialogTag);
//	
//	return pDialogTag;
//}

//CXISLDialogTag* CXISLRootTag::InsertDialogTag()
//@\@Fdialog쐬
//@FȂ
//ԂlFCXISLDialogTag*@sFNULL
BOOL CXISLRootTag::InsertDialogTag(CXISLDialogTag *pTag)
{
	if(!pTag->IsValid())
	{
		AfxMessageBox("Ódialog^Oł܂");
		return FALSE;
	}

	if(FindDTag(pTag->GetDialogID()))
	{
		AfxMessageBox("IDdialogɓo^ς݂łD");
		return FALSE;
	}
	m_xislList.AddTail(pTag);
	pTag->m_pParentTag = this;
	return TRUE;
}

//BOOL CXISLRootTag::RemoveDialogTag(LPCTSTR lpszID)
//@\@FdialogXg͂
//@F_CAOID
//ԂlFTRUE or FALSE
BOOL CXISLRootTag::RemoveDialogTag(LPCTSTR lpszID)
{
	POSITION pos = m_xislList.GetHeadPosition();
	while(pos)
	{
		POSITION posPrev = pos;
		CXISLDialogTag *pDialogTag = (CXISLDialogTag*)m_xislList.GetNext(pos);
		if(strcmp(pDialogTag->GetDialogID(),lpszID) == 0)
		{
			m_xislList.RemoveAt(posPrev);
			pDialogTag->DeleteAll();
			return TRUE;
		}
	}

	return FALSE;
}

CXISLDialogTag* CXISLRootTag::FindDTag(LPCTSTR lpszID)
{
	POSITION pos = m_xislList.GetHeadPosition();
	while(pos)
	{
		POSITION posPrev = pos;
		CXISLDialogTag *pDialogTag = (CXISLDialogTag*)m_xislList.GetNext(pos);
		if(strcmp(pDialogTag->GetDialogID(),lpszID) == 0)
			return pDialogTag;
	}
	return NULL;
}